import os
import sys
import numpy as np

from sklearn.metrics import precision_score, recall_score, roc_auc_score
from sklearn.metrics import average_precision_score


class BinaryMetrics():
    """ Calculate the rank metrics
    """

    def __init__(self):
        pass

    def __call__(self, pred: np.ndarray, true: np.ndarray):
        """ Calculate the rank metrics
            args:
                pred: predicted value
                true: true value
            output:
                dict: rank metrics. precision, recall, auc
        """
        # y_pred_label = np.round(pred)
        res_dict = {}

        # try:
        #     pre_score = precision_score(true, y_pred_label, average="macro")
        # except:
        #     pre_score = 0

        # try:
        #     rec_score = recall_score(true, y_pred_label, average="macro")
        # except:
        #     rec_score = 0

        try:
            auc_score = roc_auc_score(true, pred, average="micro")
        except:
            auc_score = 0

        # AU-PRC
        try:
            auc_prc_score = average_precision_score(true,
                                                    pred,
                                                    average="micro")
        except:
            auc_prc_score = 0

        res_dict["auroc"] = auc_score
        # res_dict["precision_score"] = pre_score
        # res_dict["recall_score"] = rec_score
        res_dict["auprc"] = auc_prc_score

        return res_dict
